<?php include './includes/header.php'; ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<div class="container my-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white">
                    <h2 class="h4 mb-0">
                        <i class="fas fa-image me-2"></i>Upload de Imagem
                    </h2>
                </div>
                <div class="card-body">
                    <?php
                    // Verifica se o formulário foi enviado
                    if (isset($_POST['submit'])) {
                        // Diretório de destino para a imagem
                        $diretorio = 'img/';
                        
                        // Verifica se o diretório existe, caso contrário cria
                        if (!is_dir($diretorio)) {
                            mkdir($diretorio, 0777, true);
                        }

                        // Caminho do arquivo JSON
                        $jsonFile = 'img/api.json';

                        // Verifica se existe uma imagem antiga no JSON
                        $imagemAntiga = '';
                        if (file_exists($jsonFile)) {
                            $jsonData = file_get_contents($jsonFile);
                            $data = json_decode($jsonData, true);
                            if (isset($data['logo'])) {
                                // Extrai o caminho local da imagem antiga
                                $urlBase = "https://launcher.painelmaster.lol/img/";
                                $imagemAntiga = str_replace($urlBase, '', $data['logo']);
                                $imagemAntiga = $diretorio . $imagemAntiga;
                            }
                        }

                        // Obtém as informações do arquivo enviado
                        $imagem = $_FILES['imagem'];
                        $nomeImagem = basename($imagem['name']);
                        $caminhoImagem = $diretorio . $nomeImagem;

                        // Move o arquivo para o diretório de destino
                        if (move_uploaded_file($imagem['tmp_name'], $caminhoImagem)) {
                            echo '<div class="alert alert-success d-flex align-items-center" role="alert">
                                    <i class="fas fa-check-circle me-2"></i>
                                    <div>Imagem enviada com sucesso!</div>
                                  </div>';

                            // Exclui a imagem antiga se existir
                            if (!empty($imagemAntiga) && file_exists($imagemAntiga) && $imagemAntiga != $caminhoImagem) {
                                if (unlink($imagemAntiga)) {
                                    echo '<div class="alert alert-info d-flex align-items-center" role="alert">
                                            <i class="fas fa-trash-alt me-2"></i>
                                            <div>Imagem antiga removida com sucesso!</div>
                                          </div>';
                                } else {
                                    echo '<div class="alert alert-warning d-flex align-items-center" role="alert">
                                            <i class="fas fa-exclamation-triangle me-2"></i>
                                            <div>Não foi possível remover a imagem antiga.</div>
                                          </div>';
                                }
                            }

                            // Caminho da imagem no formato JSON
                            $novoCaminhoImagem = "https://launcher.painelmaster.lol/" . $caminhoImagem;

                            // Atualiza o campo "logo" no JSON com o novo caminho da imagem
                            $data['logo'] = $novoCaminhoImagem;

                            // Codifica o array de volta em formato JSON
                            $jsonDataAtualizado = json_encode($data, JSON_PRETTY_PRINT);

                            // Salva o JSON atualizado de volta no arquivo
                            if (file_put_contents($jsonFile, $jsonDataAtualizado)) {
                                echo '<div class="alert alert-success d-flex align-items-center" role="alert">
                                        <i class="fas fa-check-circle me-2"></i>
                                        <div>Caminho da imagem no JSON atualizado com sucesso!</div>
                                      </div>';
                            } else {
                                echo '<div class="alert alert-danger d-flex align-items-center" role="alert">
                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                        <div>Erro ao atualizar o arquivo JSON.</div>
                                      </div>';
                            }
                        } else {
                            echo '<div class="alert alert-danger d-flex align-items-center" role="alert">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <div>Erro ao enviar a imagem.</div>
                                  </div>';
                        }
                    }
                    ?>

                    <form action="" method="POST" enctype="multipart/form-data" id="uploadForm">
                        <div class="mb-4">
                            <label for="imagem" class="form-label">
                                <i class="fas fa-file-image me-2"></i>Escolha uma imagem para upload:
                            </label>
                            <input class="form-control" type="file" name="imagem" id="imagem" required
                                   onchange="previewImage(this)">
                            <div class="form-text">Formatos suportados: JPG, PNG, GIF</div>
                        </div>
                        
                        <div class="text-center mb-4" id="imagePreviewContainer" style="display:none;">
                            <h5 class="mb-3"><i class="fas fa-eye me-2"></i>Pré-visualização</h5>
                            <img id="imagePreview" src="#" alt="Pré-visualização da imagem" 
                                 class="img-thumbnail shadow-sm" style="max-height: 200px;">
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" name="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-upload me-2"></i>Enviar Imagem
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card-footer text-muted small">
                    <i class="fas fa-info-circle me-2"></i>Esta imagem será usada como logo no seu launcher.
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Função para pré-visualizar a imagem antes do upload
    function previewImage(input) {
        const previewContainer = document.getElementById('imagePreviewContainer');
        const preview = document.getElementById('imagePreview');
        
        if (input.files && input.files[0]) {
            const reader = new FileReader();
            
            reader.onload = function(e) {
                preview.src = e.target.result;
                previewContainer.style.display = 'block';
            }
            
            reader.readAsDataURL(input.files[0]);
        } else {
            previewContainer.style.display = 'none';
            preview.src = "#";
        }
    }
</script>

<?php include './includes/footer.php'; ?>