<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

include(__DIR__ . '/includes/functions.php');
$static_url = dirname($_SERVER['SCRIPT_NAME']) . '/assets/';
include 'session_check.php';

// Configurações do arquivo de comandos 📁
$file = __DIR__ . '/commands.json';
$commands_data = [];

// Carrega comandos existentes 📥
if (file_exists($file)) {
    $commands_content = file_get_contents($file);
    $commands_data = json_decode($commands_content, true);
}

// Processamento do formulário 📝
$success_message = "";
$error_message = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Enviar novo comando 🚀
    if (isset($_POST["send_command"])) {
        $packageName = trim($_POST["packageName"]);
        
        if (empty($packageName)) {
            $error_message = "⚠️ Por favor, insira um nome de pacote válido!";
        } else {
            // Cria o novo comando 🛠️
            $new_command = [
                [
                    "status" => "success",
                    "command" => "uninstall",
                    "packageName" => $packageName
                ]
            ];
            
            // Salva no arquivo JSON 💾
            if (file_put_contents($file, json_encode($new_command, JSON_PRETTY_PRINT))) {
                $commands_data = $new_command;
                $success_message = "✅ Comando de desinstalação enviado com sucesso!";
            } else {
                $error_message = "❌ Erro ao enviar comando. Verifique as permissões do arquivo.";
            }
        }
    }
    
    // Limpar comandos 🧹
    if (isset($_POST["clear_commands"])) {
        if (file_put_contents($file, json_encode([], JSON_PRETTY_PRINT))) {
            $commands_data = [];
            $success_message = "🧹 Todos os comandos foram removidos com sucesso!";
        } else {
            $error_message = "❌ Erro ao limpar comandos. Verifique as permissões do arquivo.";
        }
    }
}

$page_title = "🛠️ Gerenciamento de Comandos";

$page_content = '<div class="container mt-5">
    <div class="card mb-5 mb-xl-12">
        <div class="card-body py-12">
            <div class="d-flex align-items-center mb-7">
                <span class="symbol symbol-50px me-5">
                    <span class="symbol-label bg-light-danger">
                        <i class="ki-outline ki-trash fs-2x text-danger"></i>
                    </span>
                </span>
                <div>
                    <h2 class="mb-1">🗑️ Comandos de Desinstalação</h2>
                    <p class="text-gray-600">Gerencie os comandos de remoção de aplicativos dos dispositivos</p>
                </div>
            </div>';

if (!empty($success_message)) {
    $page_content .= '<div class="alert alert-success d-flex align-items-center" role="alert">
        <i class="ki-outline ki-check-circle fs-2x text-success me-4"></i>
        <div class="d-flex flex-column">
            <h4 class="mb-1 text-success">Sucesso!</h4>
            <span>' . htmlspecialchars($success_message) . '</span>
        </div>
    </div>';
}

if (!empty($error_message)) {
    $page_content .= '<div class="alert alert-danger d-flex align-items-center" role="alert">
        <i class="ki-outline ki-cross-circle fs-2x text-danger me-4"></i>
        <div class="d-flex flex-column">
            <h4 class="mb-1 text-danger">Erro!</h4>
            <span>' . htmlspecialchars($error_message) . '</span>
        </div>
    </div>';
}

$page_content .= '<div class="notice d-flex bg-light-warning rounded border-warning border border-dashed p-6 mb-10">
                <i class="ki-outline ki-information-5 fs-2x text-warning me-4"></i>
                <div class="d-flex flex-stack flex-grow-1">
                    <div class="fw-semibold">
                        <h4 class="text-gray-900 fw-bold">⚠️ Aviso Importante</h4>
                        <div class="fs-6 text-gray-700">
                            <p>Este comando irá <strong class="text-danger">desinstalar permanentemente</strong> o aplicativo especificado de todos os dispositivos conectados.</p>
                            <p class="mb-0">Certifique-se de que este é realmente o aplicativo que deseja remover antes de enviar o comando.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row mb-12">
                <div class="col-xl-12 mb-15 mb-xl-0 pe-5">
                    <h4 class="mb-4">🔧 Enviar Novo Comando</h4>
                    <p class="fs-6 fw-semibold text-gray-600 py-4 m-0">
                        📦 Insira abaixo o nome do pacote do aplicativo que deseja desinstalar
                    </p>
                    
                    <form method="POST" action="">
                        <div class="form-group mb-6">
                            <label for="packageName" class="fs-5 fw-bold mb-3">📛 Nome do Pacote:</label>
                            <input 
                                type="text" 
                                class="form-control form-control-lg" 
                                name="packageName" 
                                id="packageName" 
                                placeholder="Ex: com.storeart.iptv" 
                                required>
                            <div class="text-muted mt-2">ℹ️ Normalmente no formato "com.empresa.aplicativo"</div>
                        </div>
                        
                        <input type="hidden" name="command" value="uninstall">
                        
                        <div class="d-flex justify-content-between mt-8">
                            <button type="submit" name="send_command" class="btn btn-danger btn-lg">
                                <i class="ki-outline ki-trash fs-2 me-2"></i> 🚀 Enviar Comando
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <div class="separator separator-dashed my-10"></div>
            
            <div class="row">
                <div class="col-xl-12">
                    <h4 class="mb-4">📋 Comando Atual</h4>
                    <div class="card card-flush">
                        <div class="card-body p-0">
                            <pre class="bg-light p-6 rounded">' . (!empty($commands_data) ? htmlspecialchars(json_encode($commands_data, JSON_PRETTY_PRINT)) : 'Nenhum comando ativo no momento') . '</pre>
                        </div>
                    </div>
                    
                    ' . (!empty($commands_data) ? '
                    <div class="text-end mt-6">
                        <form method="POST" action="">
                            <button type="submit" name="clear_commands" class="btn btn-warning" 
                                onclick="return confirm(\'⚠️ ATENÇÃO! Isso removerá todos os comandos. Continuar?\')">
                                <i class="ki-outline ki-broom fs-2 me-2"></i> 🧹 Limpar Comandos
                            </button>
                        </form>
                    </div>' : '') . '
                </div>
            </div>
        </div>
    </div>
</div>';

include 'includes/layout.php';
?>