<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');
$adTypeJsonPath = __DIR__ . '/ad_type.json';
$adb = new SQLite3('./api/.adb.db');
$adb3 = new SQLite3('./api/.db_logo.db');
$adb4 = new SQLite3('./api/.db_bg.db'); 
$adTypeData = json_decode(file_get_contents($adTypeJsonPath), true);
$currentAdType = $adTypeData['adType'] ?? 'manual';

if ($currentAdType === 'tmdb') {
    $adsPageUrl = "tmdb_api.php";
} else {
    $adsPageUrl = "ads.php";
}

if (!isset($_SESSION['name'])) {
    header("Location: index.php");
    exit;
}

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;

if ($_SESSION['name'] !== $loggedinuser) {
    header("Location: index.php");
    exit;
}

?>

<!doctype html>
<html lang="en" class="color-sidebar">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--favicon-->
    <link rel="icon" href="assets/images/favicon-32x32.png" type="image/png" />
    <!--plugins-->
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <!-- loader-->
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <!-- Bootstrap CSS -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/geral.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <!-- Theme Style CSS -->
    <link rel="stylesheet" href="assets/css/tema-escuro.css" />
    <link rel="stylesheet" href="assets/css/semi-dark.css" />
    <link rel="stylesheet" href="assets/css/cores-do-menu.css" />
    <link rel="stylesheet" href="assets/css/apps_styles.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@sweetalert2/theme-default/default.css" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
       <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <title>MAX REBRAND'S</title>
    <meta content="img/logo.png" property="og:image"/>
</head>

<body>
	<!--wrapper-->
	<div class="wrapper">
		<!--sidebar wrapper -->
		<div class="sidebar-wrapper" data-simplebar="true">
			<div class="sidebar-header">
				<div>
					<img src="assets/images/logo.png" class="logo-icon" alt="logo icon">
				</div>
				<div>
					<h4 class="logo-text">Bem Vindo</h4>
				</div>
				<div class="toggle-icon ms-auto"><i class='bx bx-menu'></i>
				</div>
			</div>
			<!--navigation-->
			<ul class="metismenu" id="menu">
			   
			   <li>				
					<a href="gerenciar_apps.php">
						<div class="parent-icon"><i class='bx bxs-store-alt'></i>
						</div>
						<div class="menu-title">Lista Aplicativos</div>
					</a>
				</li>
				<li>
                         <a href="painel_activation.php">
                            <div class="parent-icon"><i class='bx bxs-key'></i>
                            </div>
                            <div class="menu-title">Ativação Usuarios </div>
                        </a>
                        
                    </li>
                    <li>
                         <a href="gerenciar_ativacoes.php">
                            <div class="parent-icon"><i class='bx bx-street-view''></i>
                            </div>
                            <div class="menu-title">Gerenciar Usuarios </div>
                        </a>
                        
                    </li>
                         <li>
                         <a href="usuariosonline.php">
                            <div class="parent-icon"><i class='bx bx-sitemap''></i>
                            </div>
                            <div class="menu-title"> Usuarios Onlines </div>
                        </a>
                        
                    </li>
			    <li>				
					<a href="painel.php">
						<div class="parent-icon"><i class='bx bxl-android'></i>
						</div>
						<div class="menu-title">Enviar Aplicativos</div>
					</a>
				</li>
				
				<li>				
					<a href="logo.php">
						<div class="parent-icon"><i class='bx bx-image-alt'></i>
						</div>
						<div class="menu-title">Enviar Logotipo</div>
					</a>
				</li>
				
				<li>				
					<a href="bg.php">
						<div class="parent-icon"><i class='bx bx-image-add'></i>
						</div>
						<div class="menu-title">Anuncio Launcher</div>
					</a>
				</li>
				
				<li>				
					<a href="editar_json.php">
						<div class="parent-icon"><i class='bx bxs-bell-ring'></i>
						</div>
						<div class="menu-title">Modo de Anuncios</div>
					</a>
				</li>
				
				<li>				
					<a href="mensagem.php">
						<div class="parent-icon"><i class='bx bxl-telegram'></i>
						</div>
						<div class="menu-title">Notificar Usuarios</div>
					</a>
				</li>
				
					<li>				
					<a href="report_user.php">
						<div class="parent-icon"><i class='bx bx-mail-send'></i>
						</div>
						<div class="menu-title">Feedback Usuarios</div>
					</a>
				</li>
	
			<li>					
    <a href="uni.php">
        <div class="parent-icon"><i class='bx bx-no-signal'></i></div>
        <div class="menu-title">Excluir Aplicativos</div>
    </a>
</li>
		
                 			<li>					
    <a href="polling_control.php">
        <div class="parent-icon"><i class='bx bx-time-five'></i></div>
        <div class="menu-title">AGenda Exclusão</div>
    </a>
</li>
				<li>				
					<a href="user.php">
						<div class="parent-icon"><i class='bx bx-lock'></i></i>
						</div>
						<div class="menu-title">Meu Perfil</div>
					</a>
				</li>
				<li>				
					<a href="logout.php">
						<div class="parent-icon"><i class='bx bx-power-off'></i></i>
						</div>
						<div class="menu-title">Deslogar</div>
					</a>
				</li>
				<li>
			
			<!--end navigation-->
		</div>
		<!--end sidebar wrapper -->
		<!--start header -->
		<header>
			<div class="topbar d-flex align-items-center">
				<nav class="navbar navbar-expand">
					<div class="mobile-toggle-menu"><i class='bx bx-menu'></i>
					</div>
					
					<div class="marquee">
    <div class="marquee-content">
        <span id="vencimento-text"></span>
    </div>
</div>
					<div class="top-menu ms-auto">
						<ul class="navbar-nav align-items-center">
							
							<li class="nav-item dropdown dropdown-large">
								<a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">	<i class='bx bx-category'></i>
								</a>
								<div class="dropdown-menu dropdown-menu-end">
									<div class="row row-cols-3 g-3 p-3">
									    <div class="col text-center">
											<a href='gerenciar_apps.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bxs-store-alt'></i>
											</div></a>
											<div class="app-title">Lista Aplicativos</div>
										</div>
										<div class="col text-center">
											<a href='painel.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bxs-store-alt'></i>
											</div></a>
											<div class="app-title">Enviar Aplicativos</div>
										</div>
										<div class="col text-center">
											<a href='painel_activation.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bxl-android'></i>
											</div></a>
											<div class="app-title">Ativação Usuarios</div>
										</div>
										<div class="col text-center">
											<a href='uni.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bx-no-signal'></i>
											</div></a>
											<div class="app-title">Excluir Aplicativos</div>
										</div>
										
									    <div class="col text-center">
											<a href='logo.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='fa fa-image'></i>
											</div></a>
											<div class="app-title">LogoTipo</div>
										</div>
										
										 <div class="col text-center">
											<a href='bg.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bx-image-alt'></i>
											</div></a>
											<div class="app-title">Background</div>
										</div>
										
										 <div class="col text-center">
											<a href='mensagem.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bxl-telegram'></i>
											</div></a>
											<div class="app-title">Notificar Usuarios</div>
										</div>
										
										<div class="col text-center">
											<a href='report_user.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bx-mail-send'></i>
											</div></a>
											<div class="app-title">Feedback Usuarios</div>
										</div>
										
										<div class="col text-center">
											<a href='editar_json.php'><div class="app-box mx-auto bg-gradient-cosmic text-white"><i class='bx bxs-bell-ring'></i>
											</div></a>
											<div class="app-title">Modo de Anuncios</div>
										</div>
										
									
										
									</div>
								</div>
							</li>
							<li class="nav-item dropdown dropdown-large">
								
								<div class="dropdown-menu dropdown-menu-end">
									
									<div class="header-notifications-list">
										
									</div>
									<a href="javascript:;">
										<div class="text-center msg-footer">View All Notifications</div>
									</a>
								</div>
							</li>
							<li class="nav-item dropdown dropdown-large">
								
								<div class="dropdown-menu dropdown-menu-end">
									
									<div class="header-message-list">
										
									</div>
									<a href="javascript:;">
										<div class="text-center msg-footer">View All Messages</div>
									</a>
								</div>
							</li>
						</ul>
					</div>
					
				</nav>
			</div>
		</header>
		
		
<script>

let mensagem_filmes = "";
let mensgem_canais = "";
let mensagem_series = "";

// Realizar a requisição
axios.get("processar_permissoes_buscar_mensagens.php")
    .then(response => {
        if (response.data.status === 'sucesso') {
            const mensagens = response.data.mensagens;

            // Verificar se os elementos existem antes de definir os valores
            console.log('Mensagem Filmes:', mensagens.mensagem_filmes);
            const inputFilmes = document.getElementById('mensagemFilmes');
            mensagem_filmes = mensagens.mensagem_filmes;
            if (inputFilmes) {
                inputFilmes.value = mensagens.mensagem_filmes;
            }

            console.log('Mensagem Séries:', mensagens.mensagem_series);
            const inputSeries = document.getElementById('mensagemSeries');
            mensagem_series = mensagens.mensagem_series;
            if (inputSeries) {
                inputSeries.value = mensagens.mensagem_series;
            }

            console.log('Mensagem Canais:', mensagens.mensagem_canais);
            const inputCanais = document.getElementById('mensagemCanais');
            mensagem_canais = mensagens.mensagem_canais;
            if (inputCanais) {
                inputCanais.value = mensagens.mensagem_canais;
            }
        } else {
            console.error('Erro:', response.data.mensagem);
        }
    })
    .catch(error => {
        console.error('Erro na requisição:', error);
    });

    

    // Função para exibir o input correspondente
function mostrarInput(tipo) {
    // Esconde todos os inputs
    document.querySelectorAll('.inputMensagem').forEach(input => {
        input.style.display = 'none';
    });

    // Exibe o input correspondente ao tipo selecionado
    if (tipo === 'Filmes') {
        document.getElementById('inputFilmes').style.display = 'block';
        document.getElementById('mensagemFilmes').value = mensagem_filmes;
    } else if (tipo === 'Canais') {
        document.getElementById('inputCanais').style.display = 'block';
        document.getElementById('mensagemCanais').value = mensagem_canais;
        
    } else if (tipo === 'Séries') {
        document.getElementById('inputSeries').style.display = 'block';
        document.getElementById('mensagemSeries').value = mensagem_series;
    }
}

// Função para enviar a mensagem
function enviarMensagem() {
    let mensagem = '';
    let tipoMensagem = '';

    // Verifica qual input está visível e pega a mensagem correspondente
    if (document.getElementById('inputFilmes').style.display === 'block') {
        mensagem = document.getElementById('mensagemFilmes').value;
        tipoMensagem = 'Filmes';
        mensagem_filmes = mensagem;
    } else if (document.getElementById('inputCanais').style.display === 'block') {
        mensagem = document.getElementById('mensagemCanais').value;
        tipoMensagem = 'Canais';
        mensagem_canais = mensagem;
    } else if (document.getElementById('inputSeries').style.display === 'block') {
        mensagem = document.getElementById('mensagemSeries').value;
        tipoMensagem = 'Séries';
         mensagem_series = mensagem;
    }

    // Se a mensagem estiver vazia, mostra um alerta
    if (!mensagem) {
        alert('Por favor, insira uma mensagem.');
        return;
    }

    console.log('Tipo mensagem => ' + tipoMensagem);
    console.log('Mensagem => ' + mensagem);
    // Envia a requisição para atualizar a mensagem na DB
    axios.post('processar_permissoes_mensagem.php', {
        tipo_mensagem: tipoMensagem,
        mensagem: mensagem
    })
    .then(function(response) {
        console.log(response.data);
        alert('Mensagem enviada com sucesso!');
        $('#permissoesModal').modal('hide'); // Fecha o modal após o envio
    })
    .catch(function(error) {
        console.error(error);
        alert('Erro ao enviar mensagem');
    });
}
    
</script>


    <div class="modal fade" id="customizeModal" tabindex="-1" role="dialog" aria-labelledby="customizeModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customizeModalLabel">Personalizar</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <a class="dropdown-item" href="bg.php">
                    <i class="fa fa-image"></i>&nbsp;&nbsp;Mudar Fundo
                </a>
                <a class="dropdown-item" href="logo.php">
                    <i class="fa fa-image"></i>&nbsp;&nbsp;Mudar Logo
                </a>
                <a class="dropdown-item" href="telalogin.php">
                    <i class="fa fa-image"></i>&nbsp;&nbsp;Fundo Login
                </a>
                <a class="dropdown-item" href="edit_texto.php">
                    <i class="fa fa-envelope"></i>&nbsp;&nbsp;Enviar Mensagem
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Modal para editar permissões/mensagens -->
<div class="modal fade" id="permissoesMensagemModal" tabindex="-1" role="dialog" aria-labelledby="permissoesMensagemModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="permissoesModalLabel">Editar Mensagem das Permissões</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Botões para escolher entre Filmes, Canais e Séries -->
                <p>Selecione para qual deseja editar a mensagem que aparecerá quando o usuario não tiver a permissão adequada: </p>
                <div>
                    <button id="btnFilmes" class="btn btn-info" onclick="mostrarInput('Filmes')">Filmes</button>
                    <button id="btnCanais" class="btn btn-info" onclick="mostrarInput('Canais')">Canais</button>
                    <button id="btnSeries" class="btn btn-info" onclick="mostrarInput('Séries')">Séries</button>
                </div>
                <br>

                <!-- Inputs para cada tipo de mensagem -->
                <div id="inputFilmes" class="inputMensagem" style="display: none;">
                    <label for="mensagemFilmes">Mensagem de Filmes:</label>
                    <input type="text" id="mensagemFilmes" class="form-control" placeholder="Digite a mensagem para Filmes">
                </div>
                <div id="inputCanais" class="inputMensagem" style="display: none;">
                    <label for="mensagemCanais">Mensagem de Canais:</label>
                    <input type="text" id="mensagemCanais" class="form-control" placeholder="Digite a mensagem para Canais">
                </div>
                <div id="inputSeries" class="inputMensagem" style="display: none;">
                    <label for="mensagemSeries">Mensagem de Séries:</label>
                    <input type="text" id="mensagemSeries" class="form-control" placeholder="Digite a mensagem para Séries">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                <button type="button" class="btn btn-primary" onclick="enviarMensagem()">Enviar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="permissoesModal" tabindex="-1" role="dialog" aria-labelledby="permissoesModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="customizeModalLabel">Permissões desse usuário:</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p id="modalID"></p> <!-- Aqui será exibido o ID passado -->
                
                <!-- Checkboxes -->
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="filmesCheckbox">
                    <label class="form-check-label" for="filmesCheckbox">Filmes</label>
                </div>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="canaisCheckbox">
                    <label class="form-check-label" for="canaisCheckbox">Canais</label>
                </div>
                <div class="form-check">
                    <input type="checkbox" class="form-check-input" id="seriesCheckbox">
                    <label class="form-check-label" for="seriesCheckbox">Séries</label>
                </div>
                <br>
                
                <br>
                <!-- Botão Enviar -->
                <button type="button" class="btn btn-info" id="enviarPermissoes">Enviar</button>
            </div>
        </div>
    </div>
</div>
	
		<!--end header -->
<div class="page-wrapper">
<div class="page-content">