<?php
$log_file = __DIR__ . '/api/connection_log.json';

// Processa o formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $acao = $_POST['acao'] ?? 'salvar';

    try {
        if ($acao === 'salvar') {
            $mensagem = trim($_POST['mensagem'] ?? '');
            if (!empty($mensagem)) {
                $data = [
                    "message" => $mensagem,
                    "new_message" => true,
                    "timestamp" => date('Y-m-d H:i:s')
                ];
                file_put_contents($log_file, json_encode($data, JSON_PRETTY_PRINT));
                $sucesso = "Mensagem salva com sucesso!";
            } else {
                $erro = "Por favor, digite uma mensagem.";
            }
        } elseif ($acao === 'limpar') {
            file_put_contents($log_file, json_encode(["message" => "", "new_message" => false], JSON_PRETTY_PRINT));
            $sucesso = "Histórico limpo com sucesso!";
        }
    } catch (Exception $e) {
        $erro = "Erro ao processar a requisição: " . $e->getMessage();
    }
}

// Lê o conteúdo atual
try {
    $conteudo = file_exists($log_file) ? json_decode(file_get_contents($log_file), true) : ["message" => "", "new_message" => false];
} catch (Exception $e) {
    $erro = "Erro ao ler o arquivo de log: " . $e->getMessage();
}

include './includes/header.php';
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Mensagens</title>
    <style>
        /* Estilos gerais */
        :root {
            --primary-color: #3498db;
            --secondary-color: #2980b9;
            --success-color: #2ecc71;
            --error-color: #e74c3c;
            --light-color: #ecf0f1;
            --dark-color: #2c3e50;
            --text-color: #333;
            --border-radius: 5px;
            --box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }

        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: var(--text-color);
            background-color: #f5f5f5;
            padding: 0;
            margin: 0;
        }

        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }

        h1, h2, h3 {
            color: var(--dark-color);
            margin-bottom: 20px;
        }

        /* Alertas */
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: var(--border-radius);
            font-weight: 500;
        }

        .alert-success {
            background-color: rgba(46, 204, 113, 0.2);
            border-left: 4px solid var(--success-color);
            color: var(--success-color);
        }

        .alert-error {
            background-color: rgba(231, 76, 60, 0.2);
            border-left: 4px solid var(--error-color);
            color: var(--error-color);
        }

        /* Formulário */
        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
        }

        .form-group textarea {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: var(--border-radius);
            font-family: inherit;
            font-size: 16px;
            resize: vertical;
            min-height: 120px;
            transition: border 0.3s;
        }

        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 2px rgba(52, 152, 219, 0.2);
        }

        /* Botões */
        .btn-group {
            display: flex;
            gap: 10px;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }

        button {
            padding: 12px 20px;
            border: none;
            border-radius: var(--border-radius);
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            flex: 1;
            min-width: 150px;
        }

        button[type="submit"] {
            background-color: var(--primary-color);
            color: white;
        }

        button[type="submit"]:hover {
            background-color: var(--secondary-color);
        }

        button.limpar {
            background-color: var(--light-color);
            color: var(--dark-color);
        }

        button.limpar:hover {
            background-color: #ddd;
        }

        /* Message box */
        .message-box {
            background-color: white;
            padding: 20px;
            border-radius: var(--border-radius);
            box-shadow: var(--box-shadow);
            margin-top: 20px;
        }

        .message-box h3 {
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }

        .message-box p {
            margin-bottom: 15px;
        }

        .timestamp {
            font-size: 14px;
            color: #777;
            font-style: italic;
        }

        /* Responsividade */
        @media (max-width: 768px) {
            .container {
                padding: 15px;
            }
            
            .btn-group {
                flex-direction: column;
            }
            
            button {
                width: 100%;
            }
        }

        @media (max-width: 480px) {
            h1 {
                font-size: 24px;
            }
            
            .form-group textarea {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Sistema de Mensagens</h1>

        <?php if (isset($sucesso)): ?>
            <div class="alert alert-success"><?= htmlspecialchars($sucesso) ?></div>
        <?php endif; ?>

        <?php if (isset($erro)): ?>
            <div class="alert alert-error"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>

        <form method="post">
            <div class="form-group">
                <label for="mensagem">Mensagem:</label>
                <textarea name="mensagem" id="mensagem" rows="4" required><?= htmlspecialchars($conteudo['message']) ?></textarea>
            </div>
            <div class="btn-group">
                <button type="submit" name="acao" value="salvar">Salvar Mensagem</button>
                <button type="submit" name="acao" value="limpar" class="limpar">Limpar Histórico</button>
            </div>
        </form>

        <div class="message-box">
            <h3>Status:</h3>
            <?php if (!empty($conteudo['message'])): ?>
                <p><?= htmlspecialchars($conteudo['message']) ?></p>
                <?php if (!empty($conteudo['timestamp'])): ?>
                    <div class="timestamp">Última edição: <?= htmlspecialchars($conteudo['timestamp']) ?></div>
                <?php endif; ?>
            <?php else: ?>
                <p>Não há mensagens no momento.</p>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>

<?php include './includes/footer.php'; ?>