<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Busca</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        /* styles.css */

        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background: url('https://i.postimg.cc/SKZkjjZv/Inserir-um-t-tulo-16.png') no-repeat center center fixed; 
            background-size: cover; /* Faz a imagem cobrir toda a área */
            background-color: #e0f7fa; /* Cor de fundo alternativa para casos onde a imagem não carrega */
        }

        .container {
            text-align: center;
            background-color: #ffffff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }

        .logo img {
            width: 100px; /* Ajusta a largura da logo para 100px */
            height: 100px; /* Ajusta a altura da logo para 100px */
            object-fit: contain; /* Mantém a proporção da imagem */
        }

        .message {
            margin-top: 10px;
            font-size: 16px;
            color: #333;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .message i {
            margin-right: 8px;
            color: #007bff;
        }

        .search-box {
            margin-top: 20px;
        }

        .search-box form {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .search-box input[type="text"] {
            padding: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 4px;
            margin-bottom: 10px; /* Adiciona espaço abaixo do campo de texto */
            width: 300px; /* Ajusta a largura do campo de busca */
            padding-left: 35px; /* Espaço para o ícone dentro do campo de texto */
            background: url('https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/svgs/solid/search.svg') no-repeat 10px center;
            background-size: 20px;
        }

        .search-box button {
            padding: 12px 24px; /* Ajusta o espaço interno do botão (topo/baixo e esquerda/direita) */
            font-size: 18px; /* Ajusta o tamanho do texto */
            width: 200px; /* Ajusta a largura do botão */
            height: 40px; /* Ajusta a altura do botão */
            color: #fff;
            background-color: #007bff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .search-box button i {
            margin-right: 8px;
        }

        .search-box button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">
            <!-- Substitua 'logo.png' pelo caminho para a sua imagem de logo -->
            <img src="img/logo.png" alt="Logo">
        </div>
        <div class="message">
            <i class="fas fa-info-circle"></i>
            Olá para Renovação do seu IPTV Por favor Digite abaixo o usuário fornecido pelo seu vendedor!
        </div>
        <div class="search-box">
            <form action="search_results.php" method="GET">
                <input type="text" name="query" placeholder="Digite Username ou MAC Address..." required>
                <button type="submit"><i class="fas fa-database"></i> Buscar</button>
            </form>
        </div>
    </div>

    <!-- Inclua o rodapé, se houver -->
    <?php include('includes/footer.php'); ?>
</body>
</html>
